class Frame
{

  int iData[];

  Frame()
  {
    iData = new int [g_iFrameLength];
  }
  
  Frame getCopy()
  {
  
    Frame f = new Frame();
    
    for (int i=0; i<g_iFrameLength; i++)
    {
      f.iData[i] = iData[i];
    }
    
    return f;
    
  }
  
  int getData(int i)
  {
    return iData[i];
  }

}


class Instrument
{

  Frame frames[];

  Instrument()
  {
    frames = new Frame[g_iNumFrames];
  }

}


class SelectionInfo
{
  
  int m_iSelectedFrame = 0;
  int m_iSelectedInstrument = 0;
  
  void setFrame(int i) { m_iSelectedFrame = i; }
  void setInstrument(int i) { m_iSelectedInstrument = i; }
  
  int getFrame() { return m_iSelectedFrame; }
  int getInstrument() { return m_iSelectedInstrument; }
  
}


class DataManager
{

  Instrument m_Instruments [] = new Instrument [g_iMaxNumInstruments];
  byte m_LoadedBytes[];
  boolean m_bLoadedData = false;

  DataManager()
  {
    for (int iInstrument = 0; iInstrument < g_iMaxNumInstruments; iInstrument++)
    {
      m_Instruments[iInstrument] = new Instrument();
      for (int iFrame = 0; iFrame < g_iNumFrames; iFrame++)
      {     
        m_Instruments[iInstrument].frames[iFrame] = new Frame();
      }
    }
  }

  void loadData(String sFile)
  {

    // open a file and read its binary data 
    m_LoadedBytes = loadBytes(sFile); 

    m_bLoadedData = true;

    fillFrames();

  }


  void debugCheck()
  {
    fillBytesFromFrames();
    fillFrames();
  }


  void fillFrames()
  {

    int iCurrentLocation = 0;

    for (int iInstrument = 0; iInstrument < g_iMaxNumInstruments; iInstrument++)
    {
      
      int iInstrumentStart = g_iWavStart + (iInstrument * g_iInstrumentByteLength);

      for (int iFrame = 0; iFrame < g_iNumFrames; iFrame++)
      { 

        int iFrameStart = iInstrumentStart + (iFrame * g_iFrameByteLength);

        // two values for each location! nibbles! 
        for (int i = 0; i < g_iFrameLength; i++)
        {

          iCurrentLocation = iFrameStart + floor(i/2);

          int iByteValue = m_LoadedBytes[iCurrentLocation];
          String sBinaryByte = binary(iByteValue, 8);

          String sNibble;

          if (i%2 == 0)
          {
            sNibble = sBinaryByte.substring(0, 4);
          }
          else
          {
            sNibble = sBinaryByte.substring(4);
          }

          m_Instruments[iInstrument].frames[iFrame].iData[i] = unbinary(sNibble);

        } 
      }
    }
  }


  void fillBytesFromFrames()
  {
    for (int iInstrument = 0; iInstrument < g_iMaxNumInstruments; iInstrument++)
    {
      
      int iInstrumentStart = g_iWavStart + (iInstrument * g_iInstrumentByteLength);

      for (int iFrame = 0; iFrame < g_iNumFrames; iFrame++)
      { 

        int iFrameStart = iInstrumentStart + (iFrame * g_iFrameByteLength); 

        // two values for each location! nibbles! 
        for (int i = 0; i < g_iFrameLength/2; i++)
        {

          int iCurrentLocation = iFrameStart + (g_iInstrumentByteLength*iInstrument) + i;

          String sFirstNibble = binary(m_Instruments[iInstrument].frames[iFrame].iData[2*i], 4);
          String sSecondNibble = binary(m_Instruments[iInstrument].frames[iFrame].iData[(2*i)+1], 4);

          print(sFirstNibble + " " + sSecondNibble);
          println();

          String sByte = sFirstNibble + sSecondNibble;

          int iByteValue = unbinary(sByte);

          m_LoadedBytes[iCurrentLocation] = byte(iByteValue);

        } 

      }

    }
  }


  void saveData(String sFile)
  {

    fillBytesFromFrames();

    saveBytes(sFile, m_LoadedBytes);

  }


  int getData(SelectionInfo info, int pos)
  {  
    return getData(info.getInstrument(), info.getFrame(), pos);
  }
  
  int getData(int iInstrument, int iFrame, int pos)
  {
    return m_Instruments[iInstrument].frames[iFrame].iData[pos];
  }
  
  Frame getFrame(int iInstrument, int iFrame)
  {
    return m_Instruments[iInstrument].frames[iFrame];
  }
  
  Frame getFrame(SelectionInfo info)
  {
    return m_Instruments[info.getInstrument()].frames[info.getFrame()];
  }
  
  void setFrame(SelectionInfo info, Frame f)
  {
    m_Instruments[info.getInstrument()].frames[info.getFrame()] = f;
  }
  
  
  void setData(SelectionInfo info, int pos, int data)
  {    
    m_Instruments[info.getInstrument()].frames[info.getFrame()].iData[pos] = data;    
  }
  
  boolean loadedData()
  {
    return m_bLoadedData;
  }
  
  void nextInstrument()
  {
    int iInstrument = g_SelectionInfo.getInstrument();
    
    iInstrument++;
    
    if (iInstrument > g_iMaxNumInstruments-1) iInstrument = 0;
    
    g_SelectionInfo.setInstrument(iInstrument);
  }

  void previousInstrument()
  {
    int iInstrument = g_SelectionInfo.getInstrument();
    
    iInstrument--;
    
    if (iInstrument < 0) iInstrument = g_iMaxNumInstruments-1;
    
    g_SelectionInfo.setInstrument(iInstrument);
  }

}
